/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.io.FileWatch;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.gui.extension.Extension;
import de.willuhn.jameica.gui.extension.ExtensionRegistry;
import de.willuhn.jameica.gui.internal.action.Settings;
import de.willuhn.jameica.gui.internal.ext.ScriptingSettingsView;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.messaging.BootMessage;
import de.willuhn.jameica.messaging.BootMessageConsumer;
import de.willuhn.jameica.messaging.InvokeScriptMessageConsumer;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.SystemMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.services.MessagingService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Platform;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class ScriptingService
implements Bootable {
    public static final String QUEUE_ADDED = "jameica.scripting.added";
    public static final String QUEUE_REMOVED = "jameica.scripting.removed";
    private de.willuhn.jameica.system.Settings settings = new de.willuhn.jameica.system.Settings(ScriptingService.class);
    private ScriptEngine engine = null;
    private MessageConsumer mcInvoke = null;
    private List<File> files = null;
    private Extension settingsExt = null;
    private Events events = new Events();
    private List<BootMessage> messages = new ArrayList<BootMessage>();

    public Class<Bootable>[] depends() {
        return new Class[]{BeanService.class, MessagingService.class};
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        Application.getMessagingFactory().registerMessageConsumer(new InitMessageConsumer());
    }

    private void init() {
        this.migrate();
        this.events.clear();
        if (this.engine == null) {
            ScriptEngineManager factory = new ScriptEngineManager();
            this.engine = factory.getEngineByName("JavaScript");
        }
        if (this.engine == null) {
            Logger.warn((String)"java does not support scripting (RhinoScript)");
            return;
        }
        this.engine.put("events", this.events);
        if (this.settingsExt == null) {
            BeanService beanService = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            this.settingsExt = beanService.get(ScriptingSettingsView.class);
            ExtensionRegistry.register(this.settingsExt, de.willuhn.jameica.gui.internal.views.Settings.class.getName());
        }
        if (this.messages.size() > 0) {
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            BootMessageConsumer consumer = service.get(BootMessageConsumer.class);
            for (BootMessage msg : this.messages) {
                consumer.getMessages().remove(msg);
            }
            this.messages.clear();
        }
        this.files = this.getScripts();
        for (final File f : this.files) {
            if (!f.isFile() || !f.canRead()) {
                BootMessage msg;
                I18N i18n = Application.getI18n();
                msg = new BootMessage(i18n.tr("Script {0} nicht lesbar", f.getAbsolutePath()));
                msg.setTitle(i18n.tr("Script nicht lesbar"));
                msg.setIcon("dialog-warning-large.png");
                msg.addButton(new Button(i18n.tr("Script konfigurieren..."), new Settings(), Application.getI18n().tr("Scripting")));
                Application.getMessagingFactory().getMessagingQueue("jameica.boot").queueMessage(msg);
                this.messages.add(msg);
                continue;
            }
            this.eval(f);
            FileWatch.addFile((File)f, (Observer)new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    Logger.info((String)("auto-reloading script " + f));
                    ScriptingService.this.eval(f);
                }
            });
        }
        this.mcInvoke = new InvokeScriptMessageConsumer();
        Application.getMessagingFactory().getMessagingQueue("jameica.scripting").registerMessageConsumer(this.mcInvoke);
    }

    private void migrate() {
        if (this.settings.getString("migrated", null) != null) {
            return;
        }
        File file = new File(Application.getConfig().getConfigDir(), "de.willuhn.jameica.scripting.Plugin.properties");
        if (file.exists() && file.canRead()) {
            String[] keys;
            Logger.info((String)("migrating scripting-settings from " + file));
            de.willuhn.util.Settings source = new de.willuhn.util.Settings(null, file);
            for (String s : keys = source.getAttributes()) {
                String value = source.getString(s, null);
                Logger.info((String)("  " + s + "=" + value));
                this.settings.setAttribute(s, value);
            }
            this.settings.setAttribute("migrated", DateUtil.DEFAULT_FORMAT.format(new Date()));
            Logger.info((String)("deleting " + file));
            if (!file.delete()) {
                Logger.warn((String)("could not delete " + file));
                file.deleteOnExit();
            }
        }
    }

    public void shutdown() {
        try {
            if (this.files != null) {
                for (File f : this.files) {
                    FileWatch.removeFile((File)f);
                }
            }
        }
        finally {
            this.engine = null;
            this.files = null;
            Application.getMessagingFactory().getMessagingQueue("jameica.scripting").unRegisterMessageConsumer(this.mcInvoke);
        }
    }

    public void reload() {
        try {
            Logger.info((String)"restarting scripting service");
            this.shutdown();
            this.init();
        }
        catch (Exception e) {
            Logger.error((String)"unable to restart scripting service", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eval(File f) {
        Logger.info((String)("executing script " + f));
        if (!(f.exists() && f.canRead() && f.isFile())) {
            Logger.warn((String)"  not found or not readable, skipping");
            return;
        }
        BufferedReader r = null;
        try {
            String encoding = this.settings.getString("script.encoding", null);
            r = encoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), encoding)) : new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            this.getEngine().eval(r);
        }
        catch (Exception e) {
            try {
                Logger.error((String)"error while loading script", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{r});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{r});
        }
        IOUtil.close((Closeable[])new Closeable[]{r});
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }

    public List<String> getFunction(String event) {
        return this.events.get(event);
    }

    public List<File> getScripts() {
        Platform platform = Application.getPlatform();
        String[] list = this.settings.getList("scripts", new String[0]);
        ArrayList<File> files = new ArrayList<File>();
        for (String s : list) {
            if (s == null || s.length() == 0) continue;
            try {
                files.add(new File(platform.toAbsolute(s)));
            }
            catch (Exception e) {
                Logger.error((String)("unable to determine canonical path of script " + s), (Throwable)e);
            }
        }
        Collections.sort(files);
        return files;
    }

    public boolean contains(File file) throws IOException {
        Platform platform = Application.getPlatform();
        File test = new File(platform.toAbsolute(file.getAbsolutePath()));
        List<File> existing = this.getScripts();
        for (File f : existing) {
            if (!f.equals(test)) continue;
            return true;
        }
        return false;
    }

    public void addScript(File file) throws ApplicationException {
        if (file == null) {
            return;
        }
        try {
            if (this.contains(file)) {
                throw new ApplicationException(Application.getI18n().tr("Script-Datei {0} ist bereits registriert", file.getAbsolutePath()));
            }
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)("unable to convert path " + file + " to canonical form"), (Throwable)e);
            throw new ApplicationException(Application.getI18n().tr("Fehler beim Import der Script-Datei {0}: {1}", new String[]{file.getAbsolutePath(), e.getMessage()}));
        }
        List<File> existing = this.getScripts();
        Logger.info((String)("adding script " + file));
        existing.add(file);
        Platform platform = Application.getPlatform();
        ArrayList<String> list = new ArrayList<String>();
        for (File f : existing) {
            list.add(platform.toRelative(f.getAbsolutePath()));
        }
        this.settings.setAttribute("scripts", list.toArray(new String[list.size()]));
        this.reload();
        Application.getMessagingFactory().getMessagingQueue(QUEUE_ADDED).sendMessage(new QueryMessage(file));
    }

    public void removeScript(File file) {
        if (file == null) {
            return;
        }
        List<File> existing = this.getScripts();
        ArrayList<String> newList = new ArrayList<String>();
        for (File f : existing) {
            try {
                if (f.getCanonicalPath().equals(file.getCanonicalPath())) continue;
                newList.add(f.getAbsolutePath());
            }
            catch (Exception e) {
                Logger.error((String)("unable to convert path " + file + " to canonical form"), (Throwable)e);
            }
        }
        if (existing.size() == newList.size()) {
            return;
        }
        Logger.info((String)("removing script " + file));
        this.settings.setAttribute("scripts", newList.toArray(new String[newList.size()]));
        this.reload();
        Application.getMessagingFactory().getMessagingQueue(QUEUE_REMOVED).sendMessage(new QueryMessage(file));
    }

    public class Events {
        private Map<String, List<String>> mapping = new HashMap<String, List<String>>();

        public List<String> get(String event) {
            return this.mapping.get(event);
        }

        public void add(String event, String function) {
            List<String> functions = this.get(event);
            if (functions == null) {
                functions = new ArrayList<String>();
                this.mapping.put(event, functions);
            }
            if (!functions.contains(function)) {
                Logger.info((String)("registering script function \"" + function + "\" for event \"" + event + "\""));
                functions.add(function);
            }
        }

        public void clear() {
            this.mapping.clear();
        }
    }

    private class InitMessageConsumer
    implements MessageConsumer {
        private InitMessageConsumer() {
        }

        @Override
        public boolean autoRegister() {
            return false;
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{SystemMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            SystemMessage msg = (SystemMessage)message;
            if (msg.getStatusCode() == 1) {
                ScriptingService.this.init();
            }
        }
    }
}

